<?php defined('PF_VERSION') OR exit('Access denied'); ?>
<?php
    $current = isset($_GET['current']) ? $_GET['current'] : '';
?>
<div class="hidden" id="messageErrorJS">
    <ul>
        <li class="errorNumberAddMore"><?php echo __('You can add maximum 50 questions at a time', 'faq'); ?></li>
        <li class="confirmDelete"><?php echo __('Are you sure to delete this item?', 'faq'); ?></li>
        <li class="validatorTitle"><?php echo __('Title must be in the range of 2 to 255 characters', 'faq'); ?></li>
        <li class="validatorDescription"><?php echo __('Description must be in the range of 1 to 500 characters', 'faq'); ?></li>
    </ul>
</div>
<div class="row pull-right btnTop">
    <div class="col-md-12">
        <?php 
            add_toolbar_button(form_button("<i class='fa fa-check'></i> " . __('Save', 'faq'), array('class' => 'btn btn-primary btnSave')));
            add_toolbar_button(form_button(" " . __('Cancel', 'faq'), array('onclick' => "window.location='" . admin_url(array('admin-page' => 'faq', 'current' => $current), false) . "'", 'class' => 'btn btn-default')));
        ?>
    </div>
</div><!--end button-->
<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title"><i class="fa fa-tasks"></i> <?php echo __('FAQs', 'faq'); ?></h3>
    </div>
    <div class="panel-body">
        <form action="<?php echo admin_url('&act=create') ?>" class="form-horizontal" method="post" role="form">
            <div class="row">
                <div class="cu">
                    <?php require_once ABSPATH . '/includes/common/plugin/views/alert.php'; ?>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group <?php echo state_validator('title', $validated); ?>">
                                <label for="title" class="col-sm-1 control-label"><?php echo __('Title', 'faq'); ?> <span>*</span></label>
                                <div class="col-sm-11">
                                    <?php
                                    echo form_input(array('name' => 'title', 'class' => 'form-control', 'tabindex' => 1));
                                    echo alert_error_validator('title', $validated);
                                    echo form_input(array('name' => 'number_qa', 'type' => 'hidden'));
                                    ?>
                                </div>
                            </div>

                            <div class="form-group <?php echo state_validator('status', $validated); ?>">
                                <label for="status" class="col-sm-1 control-label"><?php echo __('Status', 'faq'); ?></label>
                                <div class="col-sm-5">
                                    <?php
                                    echo form_dropdown('status', $status, array(), "class='form-control' tabindex='2'");
                                    echo alert_error_validator('status', $validated);
                                    ?>
                                </div>
                            </div>

                            <div class="form-group <?php echo state_validator('description', $validated); ?>">
                                <label for="Description" class="col-sm-1 control-label"><?php echo __('Description', 'faq'); ?></label>
                                <div class="col-sm-11">
                                    <?php
                                    echo form_textarea(array('name' => 'description', 'class' => 'form-control', 'rows' => 3, 'tabindex' => 3));
                                    echo alert_error_validator('description', $validated);
                                    ?>
                                </div>
                            </div>

                            <hr/>
                            <div id="listQuestion">
                                <?php
                                for ($i = 0; $i < $number_qa; $i++):
                                    ?>
                                    <div class="qaItem">
                                        <span class="glyphicon glyphicon-remove btnRemoveQA"></span>
                                        <div class="form-group">
                                            <label for="question" class="col-sm-1 control-label"><?php echo __('Question', 'faq'); ?></label>
                                            <div class="col-sm-11">
                                                <?php
                                                echo form_input(array('name' => 'question[]', 'class' => 'form-control', 'value' => isset($list_qa['question'][$i]) ? $list_qa['question'][$i] : '' ));
                                                ?>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="answer" class="col-sm-1 control-label"><?php echo __('Answer', 'faq'); ?></label>
                                            <div class="col-sm-11">
                                                <?php
                                                echo form_textarea(array('name' => 'answer[]', 'class' => 'form-control', 'rows' => 3), isset($list_qa['answer'][$i]) ? $list_qa['answer'][$i] : '');
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php endfor; ?>
                            </div>
                            <div class="form-group" id="addMore">
                                <label class="col-sm-1 control-label"></label>
                                <div class="col-sm-11">
                                    <div class="callout callout-info">
                                        <h4><?php echo __('Please input number of questions and click Add', 'faq'); ?></h4>
                                        <p><?php echo __('You can add maximum 50 questions at a time. You can order questions by dragging them', 'faq'); ?></p>
                                    </div>
                                    <div class="form-inline">
                                        <input type="text" class="form-control" value="1">
                                        <button type="button" class="btn btn-info"><?php echo __('Add', 'faq'); ?></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!--end title-->
                </div>
            </div>
        </form>
    </div>
</div>
<div class="controlClone hidden">
    <div id="qa" class="qaItem qaAppend">
        <span class="glyphicon glyphicon-remove btnRemoveQA"></span>
        <div class="form-group">
            <label for="question" class="col-sm-1 control-label"><?php echo __('Question', 'faq'); ?></label>
            <div class="col-sm-11">
                <?php
                echo form_input(array('name' => 'question[]', 'class' => 'form-control'));
                ?>
            </div>                        
        </div>
        <div class="form-group">
            <label for="answer" class="col-sm-1 control-label"><?php echo __('Answer', 'faq'); ?></label>
            <div class="col-sm-11">
                <?php
                echo form_textarea(array('name' => 'answer[]', 'class' => 'form-control', 'rows' => 3));
                ?>
            </div>
        </div>
    </div>
</div>

